<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Bhaktibhumi</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">

    @include('common.header-link')

</head>

<body>

    <!-- Spinner Start -->
    <div id="spinner"
        class="show bg-white position-fixed translate-middle w-100 vh-100 top-50 start-50 d-flex align-items-center justify-content-center">
        <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
            <span class="sr-only">Loading...</span>
        </div>
    </div>
    <!-- Spinner End -->

    <!-- Navbar & Hero Start -->
    <div class="container-fluid nav-bar sticky-top px-4 py-2 py-lg-0">
        @include('common.header')
    </div>
    <!-- Navbar & Hero End -->

    <!-- Header Start -->
    <div class="container-fluid bg-breadcrumb">
        <div class="container text-center py-5" style="max-width: 900px;">
            <h4 class="text-white display-4 mb-4 wow fadeInDown" data-wow-delay="0.1s">Dharamshala</h4>
            <ol class="breadcrumb d-flex justify-content-center mb-0 wow fadeInDown" data-wow-delay="0.3s">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <!-- <li class="breadcrumb-item"><a href="#">Pages</a></li> -->
                <li class="breadcrumb-item active text-primary">Dharamshala</li>
            </ol>
        </div>
    </div>
    <!-- Header End -->

    <!-- Blog Start -->
    <div class="container-fluid blog py-5">
        <div class="container py-5">
            <div class="text-center mx-auto pb-5 wow fadeInUp" data-wow-delay="0.2s" style="max-width: 800px;">
                <h4 class="text-primary">Dharamshala</h4>
                <h1 class="display-5 mb-4">Where every stay is a peacefull Escape</h1>
                <!-- <p class="mb-0">Lorem ipsum dolor, sit amet consectetur adipisicing elit. Tenetur adipisci facilis cupiditate recusandae aperiam temporibus corporis itaque quis facere, numquam, ad culpa deserunt sint dolorem autem obcaecati, ipsam mollitia hic.
                    </p> -->
            </div>
            <div class="row g-4">
                @foreach ($dharmashala as $dharamshaladata )
                <div class="col-lg-4 wow fadeInUp" data-wow-delay="0.2s">
                    <div class="blog-item">
                        <div class="blog-img">
                            <a href="#">
                                <!-- <img src="{{asset('assets/img/dharmashala.jpg')}}" class="img-fluid w-100 rounded-top"
                                    alt="Image"> -->
                                <!-- <img src="http://192.168.1.12:8001/{{ $dharamshaladata->dharmashala_image }}" class="img-fluid w-100 rounded-top"
                                    alt="Image"> -->




                                @if (Str::contains($dharamshaladata->dharmashala_image, 'website-partner'))
                                <img src="{{ asset($dharamshaladata->dharmashala_image) }}"
                                    class="img-fluid w-100 rounded-top" alt="Image">
                                @else
                                <img src="{{ env('DASHBOARD_URL') }}{{ $dharamshaladata->dharmashala_image }}"
                                    class="img-fluid w-100 rounded-top" alt="Image">
                                @endif
                            </a>
                        </div>
                        <div class="blog-content p-4">
                            <a href="#" class="h4 d-inline-block mb-4">{{ $dharamshaladata->dharamshala_name }}</a>
                            <p class="mb-4">{{ $dharamshaladata->dharamshala_address }}</p>
                            <a href="{{ route('dharamshala-detail', $dharamshaladata->partner_with_us_id) }}" class="btn btn-primary rounded-pill py-2 px-4">Book Now <i
                                    class="fas fa-arrow-right ms-2"></i></a>
                        </div>
                    </div>
                </div>
                @endforeach

            </div>
        </div>
    </div>
    <!-- Blog End -->

    <!-- Footer Start -->
    @include('common.footer')


    <!-- Back to Top -->
    <a href="#" class="btn btn-primary btn-lg-square rounded-circle back-to-top"><i class="fa fa-arrow-up"></i></a>


    @include('common.footer-link')


</body>

</html>