<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>{{ $dharamshala->dharamshala_name }}</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    @include('common.header-link')
</head>

<body>

    <div class="container-fluid bg-breadcrumb">
        <div class="container text-center py-5">
            <h4 class="text-white display-4">{{ $dharamshala->dharamshala_name }}</h4>
            <ol class="breadcrumb d-flex justify-content-center mb-0">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{ url('dharamshala') }}">Dharamshala</a></li>
                <li class="breadcrumb-item active text-primary">Detail</li>
            </ol>
        </div>
    </div>

    <div class="container py-5">

        <!-- Image Section -->
        <div class="row mb-4">
            <div class="col-lg-12 text-center">
                <!-- <img src="http://192.168.1.12:8001/{{ $dharamshala->dharmashala_image }}" 
                     class="img-fluid rounded"
                     style="max-height: 450px; object-fit: cover;"> -->
                

                @if (Str::contains($dharamshala->dharmashala_image, 'website-partner'))
                <img src="{{ asset($dharamshala->dharmashala_image) }}"
                    class="img-fluid rounded"
                    style="max-height: 450px; object-fit: cover;">
                @else
                <img src="{{ env('DASHBOARD_URL') }}{{ $dharamshala->dharmashala_image }}"
                    class="img-fluid rounded"
                    style="max-height: 450px; object-fit: cover;">
                @endif





                
            </div>
        </div>

        <!-- Details Section -->
        <div class="row">
            <div class="col-lg-8">

                <!-- <h2 class="mb-3">{{ $dharamshala->dharamshala_name }}</h2>

                <p class="text-muted">
                    <i class="fa fa-map-marker-alt me-2"></i>
                    {{ $dharamshala->dharamshala_address }}
                </p>

                <h5 class="mt-4">Description</h5>
                <p>{{ $dharamshala->description ?? 'No description available.' }}</p>

                <h5 class="mt-4">Facilities</h5>
                <ul>
                    @if($dharamshala->facilities)
                        @foreach(explode(',', $dharamshala->facilities) as $facility)
                            <li>{{ trim($facility) }}</li>
                        @endforeach
                    @else
                        <li>No facilities listed.</li>
                    @endif
                </ul> -->

                <div class="row g-4">
                    @foreach ($rooms as $dharamshaladata )
                    <div class="col-lg-4 wow fadeInUp" data-wow-delay="0.2s">
                        <div class="blog-item">
                            <div class="blog-img">

                                @php
                                $images = json_decode($dharamshaladata->room_imgs, true) ?? [];
                                @endphp

                                <div id="roomCarousel{{ $dharamshaladata->room_id }}" class="carousel slide" data-bs-ride="carousel">
                                    <div class="carousel-inner">

                                        @foreach ($images as $key => $img)
                                        <div class="carousel-item {{ $key == 0 ? 'active' : '' }}">
                                            <img src="{{ env('DASHBOARD_URL') }}dashboard-partner/room-imgs/{{ $img }}"
                                                class="img-fluid w-100 rounded-top"
                                                alt="Room Image">
                                        </div>
                                        @endforeach

                                    </div>

                                    <button class="carousel-control-prev" type="button"
                                        data-bs-target="#roomCarousel{{ $dharamshaladata->room_id }}"
                                        data-bs-slide="prev">
                                        <span class="carousel-control-prev-icon"></span>
                                    </button>

                                    <button class="carousel-control-next" type="button"
                                        data-bs-target="#roomCarousel{{ $dharamshaladata->room_id }}"
                                        data-bs-slide="next">
                                        <span class="carousel-control-next-icon"></span>
                                    </button>

                                </div>

                            </div>


                            <div class="blog-content p-4">
                                <a href="#" class="h4 d-inline-block mb-4">{{ $dharamshaladata->rent }}</a>
                                <p class="mb-4"></p>
                                <a href="" class="btn btn-primary rounded-pill py-2 px-4">Book Now <i
                                        class="fas fa-arrow-right ms-2"></i></a>
                            </div>
                        </div>
                    </div>
                    @endforeach

                </div>

            </div>

            <!-- Right Side Booking Box -->
            <div class="col-lg-4">
                <div class="card p-4 shadow">

                    <h4 class="mb-3">{{ $dharamshala->dharamshala_name }}</h4>

                    <p><strong>Name:</strong><br>
                        {{ $dharamshala->dharamshala_name }}
                    </p>

                    <p><strong>Address:</strong><br>
                        {{ $dharamshala->dharamshala_address }}
                    </p>


                </div>
            </div>
        </div>

    </div>

    @include('common.footer')
    @include('common.footer-link')

</body>

</html>