<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Bhaktibhumi</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">

    <?php echo $__env->make('common.header-link', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</head>

<body>


    <!-- Spinner Start -->
    <div id="spinner"
        class="show bg-white position-fixed translate-middle w-100 vh-100 top-50 start-50 d-flex align-items-center justify-content-center">
        <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
            <span class="sr-only">Loading...</span>
        </div>
    </div>
    <!-- Spinner End -->

    <!-- Navbar & Hero Start -->
    <div class="container-fluid nav-bar sticky-top px-4 py-2 py-lg-0">
        <?php echo $__env->make('common.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>
    <!-- Navbar & Hero End -->

    <!-- Header Start -->
    <div class="container-fluid bg-breadcrumb">
        <div class="container text-center py-5" style="max-width: 900px;">
            <h4 class="text-white display-4 mb-4 wow fadeInDown" data-wow-delay="0.1s">Partner With Us</h4>
            <ol class="breadcrumb d-flex justify-content-center mb-0 wow fadeInDown" data-wow-delay="0.3s">
                <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                <!-- <li class="breadcrumb-item"><a href="#">Pages</a></li> -->
                <li class="breadcrumb-item active text-primary">Partner With Us</li>
            </ol>
        </div>
    </div>
    <!-- Header End -->

    <!-- Contact Start -->
    <div class="container-fluid contact py-5">
        <div class="container py-5">
            <div class="row g-5">
                <div class="col-12 col-xl-6 wow fadeInUp" data-wow-delay="0.2s">
                    <div>
                        <div class="pb-5">
                            <h4 class="text-primary">Bhaktibhumi</h4>
                            <p class="mb-0">Partner with bhaktibhumi.com - India's 1st online dharamshala booking
                                platform ! Get more booking , boost revenue & reach lakhs of devotees nation wide . Free
                                listing , zero upfront cost - join the digital devotional revolution . .</p>
                        </div>
                        <div class="row g-4">
                            <div class="col-lg-6">
                                <div class="contact-add-item rounded bg-light p-4">
                                    <div class="contact-icon text-primary mb-4">
                                        <i class="fas fa-map-marker-alt fa-2x"></i>
                                    </div>
                                    <div>
                                        <h4>Address</h4>
                                        <p class="mb-0">C-4 First Flour, Narayan Plaza, Samyak Arcade Cannought Place,
                                            Aurangabad (chh Sambhajinagar)</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="contact-add-item rounded bg-light p-4" style="height: 213px;">
                                    <div class="contact-icon text-primary mb-4">
                                        <i class="fas fa-envelope fa-2x"></i>
                                    </div>
                                    <div>
                                        <h4>Contact</h4>
                                        <p class="mb-0">Bhaktibhumi2025@gmail.com</p>
                                        <p class="mb-0">+91 8446241008</p>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12">
                                <div class="d-flex justify-content-around bg-light rounded p-4">
                                    <a class="btn btn-xl-square btn-primary rounded-circle" href="#"><i
                                            class="fab fa-facebook-f"></i></a>
                                    <a class="btn btn-xl-square btn-primary rounded-circle" href="#"><i
                                            class="fab fa-twitter"></i></a>
                                    <a class="btn btn-xl-square btn-primary rounded-circle" href="#"><i
                                            class="fab fa-instagram"></i></a>
                                    <a class="btn btn-xl-square btn-primary rounded-circle" href="#"><i
                                            class="fab fa-linkedin-in"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 wow fadeInUp" data-wow-delay="0.4s">
                    <div class="bg-light p-5 rounded h-100">
                        <h4 class="text-primary mb-4">Partner With Us</h4>
                        <form action="<?php echo e(route('otp-check')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="row g-4">
                                <!-- Dharamshala ID -->
                                <div class="col-lg-12 col-xl-12">
                                    <div class="form-floating">
                                        <input type="text" class="form-control" id="dharamshala_id" name="dharamshala_id"
                                            value="<?php echo e($data->dharamshala_id); ?>" required readonly>
                                        <label for="dharamshala_id">Dharamshala ID <span class="text-danger">*</span></label>
                                    </div>
                                </div>

                                <!-- Phone number -->
                                <div class="col-lg-12 col-xl-12">
                                    <div class="form-floating">
                                        <input type="text" class="form-control" id="phone_number" name="phone_number"
                                            value="<?php echo e($data->phone_number); ?>" required readonly>
                                        <label for="phone_number">Phone Number <span class="text-danger">*</span></label>
                                    </div>
                                </div>
                                <?php if(!$data->otp): ?>
                                <div class="mt-2">
                                    <button type="button" id="sendOtpBtn" class="btn btn-outline-primary btn-sm">Send OTP</button>
                                </div>
                                <?php endif; ?>

                                <!-- OTP input (5 digits for testing) -->
                                <div class="col-lg-12 col-xl-12 text-center">
                                    <label class="form-label fw-bold mb-2">Enter OTP</label>
                                    <div class="d-flex justify-content-between">
                                        <input type="text" class="form-control text-center mx-1 otp-input" maxlength="1" required>
                                        <input type="text" class="form-control text-center mx-1 otp-input" maxlength="1" required>
                                        <input type="text" class="form-control text-center mx-1 otp-input" maxlength="1" required>
                                        <input type="text" class="form-control text-center mx-1 otp-input" maxlength="1" required>
                                        <input type="text" class="form-control text-center mx-1 otp-input" maxlength="1" required>
                                        <input type="text" class="form-control text-center mx-1 otp-input" maxlength="1" required>
                                    </div>
                                    <input type="hidden" name="otp" id="otp">
                                </div>

                                <!-- Submit button -->
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary w-100 py-3">Verify OTP</button>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>
                <div class="col-12 wow fadeInUp" data-wow-delay="0.2s">
                    <div class="rounded">
                        <iframe class="rounded w-100"
                            src="https://www.google.com/maps/embed?pb=!1m16!1m12!1m3!1d1767.5966641660723!2d75.3635185564297!3d19.87921756485629!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!2m1!1sC-4%20First%20Flour%2C%20Narayan%20Plaza%2C%20Samyak%20Arcade%20Cannought%20Place%2C%20Aurangabad%20(chh%20Sambhajinagar)!5e1!3m2!1sen!2sin!4v1749925648766!5m2!1sen!2sin"
                            width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy"
                            referrerpolicy="no-referrer-when-downgrade"></iframe>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Contact End -->

    <?php echo $__env->make('common.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Back to Top -->
    <a href="#" class="btn btn-primary btn-lg-square rounded-circle back-to-top"><i class="fa fa-arrow-up"></i></a>


    <?php echo $__env->make('common.footer-link', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- OTP Auto-focus Script -->
    <script>
    document.addEventListener("DOMContentLoaded", function () {
        const inputs = document.querySelectorAll(".otp-input");
        const hiddenOtp = document.getElementById("otp");

        inputs.forEach((input, index) => {
            input.addEventListener("input", function () {
                // Allow only numbers
                this.value = this.value.replace(/[^0-9]/g, "");

                if (this.value.length === 1 && index < inputs.length - 1) {
                    inputs[index + 1].focus();
                }
                collectOtp();
            });

            input.addEventListener("keydown", function (e) {
                if (e.key === "Backspace" && !this.value && index > 0) {
                    inputs[index - 1].focus();
                }
                collectOtp();
            });
        });

        function collectOtp() {
            let otpValue = "";
            inputs.forEach(inp => otpValue += inp.value);
            hiddenOtp.value = otpValue;
        }
    });
</script>

<script>
    document.getElementById('sendOtpBtn').addEventListener('click', function () {
        let dharamshalaId = document.getElementById('dharamshala_id').value;

        fetch("<?php echo e(route('send.otp')); ?>", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
                "X-CSRF-TOKEN": "<?php echo e(csrf_token()); ?>"
            },
            body: JSON.stringify({
                dharamshala_id: dharamshalaId
            })
        })
        .then(res => res.json())
        .then(data => {
            if(data.success){
                alert("OTP sent successfully!");
                window.location.reload(); // Reload to show OTP fields
            } else {
                alert("Failed to send OTP.");
            }
        })
        .catch(err => console.log(err));
    });
</script>

</body>

</html>
<?php /**PATH C:\xampp2.0\htdocs\Bhaktibhumi\resources\views/partner-with-us-otp.blade.php ENDPATH**/ ?>