<?php

namespace App\Http\Controllers;

use App\Mail\OtpMail;
use App\Models\PartnerwithusModel;

use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Mail;

class PartnerwithusController extends Controller
{

    public function Addstorepartnerwithus(Request $request)
    {
        $validated = $request->validate([
            'dharamshala_id' => 'required',
            'name' => 'required|string|max:255',
            'dharamshala_name' => 'required|string|max:255',
            'phone_number' => 'required|digits:10',
            'email' => 'required|email',
            'address' => 'required|string|max:255',
            'dharamshala_address' => 'required|string|max:255',
            'auth_sign' => 'required',
            'auth_img' => 'required',
            'auth_aadhar' => 'required|digits:12',
        ]);

        $path = 'website-partner/partner-with-us/';
        // Handle auth_sign
        if ($request->hasFile('auth_sign')) {
            $file1 = $request->file('auth_sign');
            $filename1 = 'auth_sign' . time() . '.' . $file1->getClientOriginalExtension();
            $file1->move(public_path($path), $filename1);
            $auth_sign = $path . $filename1;
        } else {
            $auth_sign = null;
        }

        // Handle auth_img
        if ($request->hasFile('auth_img')) {
            $file1 = $request->file('auth_img');
            $filename1 = 'auth_img' . time() . '.' . $file1->getClientOriginalExtension();
            $file1->move(public_path($path), $filename1);
            $auth_img = $path . $filename1;
        } else {
            $auth_img = null;
        }

        $data = PartnerwithusModel::create(array_merge($validated, [
            'auth_sign' => $auth_sign,
            'auth_img' => $auth_img,
            'status' => 1,
            'admin_status' => 0,
        ]));

        return redirect()->route('partner-with-us-otp', ['dharamshala_id' => $data->dharamshala_id])->with('success', 'Partner With Us Added Successfully');
    }


    public function Dharamshalacheckdharamshalaid(Request $request)
    {
        $dharamshala_id = $request->dharamshala_id;
        $data = PartnerwithusModel::where('dharamshala_id', $request->dharamshala_id)->first();
        // dd($data);
        if (! $data) {
            return redirect()->route('partner-withus-registration', parameters: ['dharamshala_id' => $dharamshala_id]);
        }
        if ($data->status == 1) {
            return redirect()->route('partner-with-us-otp', ['dharamshala_id' => $data->dharamshala_id])->with('success', 'Please Verify Your OTP');
        } elseif ($data->status == 2) {
            return redirect()->route('home')->with('success', 'Your Dharamshala is already registered and verified.');
        } else {
            return redirect()->route('partner-withus-registration', parameters: ['dharamshala_id' => $dharamshala_id]);
        }




        // if (! $data) {
        //     return redirect()->route('partner-withus-registration', parameters: ['dharamshala_id' => $dharamshala_id]);
        // } else {
        //     return redirect()->route('partner-with-us-otp', ['dharamshala_id' => $dharamshala_id])->with('success', 'Please Verify Your OTP');
        // }
    }

    public function PartnerWithUsregistration(Request $request)
    {
        $dharamshala_id = $request->query('dharamshala_id');
        return view('partner-withus-registration', compact('dharamshala_id'));
    }

    public function PartnerWithUsotp(Request $request, $dharamshala_id)
    {
        $dharamshala = $request->all();
        // dd($dharamshala);


        $data = PartnerwithusModel::where('dharamshala_id', $dharamshala_id)->first();
        // dd($data);


        return view('partner-with-us-otp', compact('data'));
    }

    public function sendOtp(Request $request)
    {
        $dharamshala_id = $request->dharamshala_id;
        $otp = rand(100000, 999999);

        $data = PartnerwithusModel::where('dharamshala_id', $dharamshala_id)->first();
        if (!$data) {
            return response()->json(['success' => false, 'message' => 'Invalid Dharamshala ID']);
        }

        $email = $data->email;
        $minutes = 5;
        // store otp in cache for $minutes
        Cache::put('otp_' . $email, $otp, now()->addMinutes($minutes));

        PartnerwithusModel::where('dharamshala_id', $data->dharamshala_id)
            ->update([
                'otp' => $otp,
                'otp_expires_at' => Carbon::now()->addMinutes(5),
            ]);

        try {
            Mail::to($email)->send(new OtpMail($otp, $minutes));
            return response()->json(['success' => true, 'message' => 'OTP sent']);
        } catch (\Exception $e) {
            // optional: Log::error($e->getMessage());
            return response()->json(['success' => false, 'message' => 'Mail sending failed: ' . $e->getMessage()], 500);
        }

    }


    public function verifyOtp(Request $request)
    {
        $request->validate([
            'dharamshala_id' => 'required',
            'otp' => 'required|digits:6',
        ]);

        $partner = PartnerwithusModel::where('dharamshala_id', $request->dharamshala_id)->first();

        if (! $partner) {
            return back()->with('error', 'Invalid Dharamshala ID');
        }

        if ($partner->otp === $request->otp && $partner->otp_expires_at > now()) {
            $partner->update([
                'otp' => null,
                'otp_expires_at' => null,
                'status' => 2,
            ]);

            return redirect()->route('home')->with('success', 'OTP Verified Successfully!');
        }

        return back()->with('error', 'Invalid or Expired OTP');
    }
}
