<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use App\Models\User;
use Auth;
use Illuminate\Support\Facades\Cookie;

class AuthController extends Controller
{
    public function Signup()
    {
        return view('sign-up');
    }

    public function Addstoreusers(Request $request)
    {
        $validated = $request->validate([
            'full_name' => 'required|string|max:255',
            'gender' => 'required',
            'date_of_birth' => 'required|date',
            'phone_number' => 'required|digits:10',
            'email' => 'required|email|unique:users,email',
            'address' => 'required',
            'aadhar_number' => 'nullable|digits:12',
            'pan_number' => 'nullable|string|max:10',
            'password' => 'required|string|min:6|confirmed',
        ]);

        $data = [
            'name' => $request->full_name,
            'full_name' => $request->full_name,
            'gender' => $request->gender,
            'date_of_birth' => $request->date_of_birth,
            'phone_number' => $request->phone_number,
            'email' => $request->email,
            'address' => $request->address,
            'aadhar_number' => $request->aadhar_number,
            'pan_number' => $request->pan_number,
            'user_type' => 'user',
            'password' => Hash::make('password'),
            'remember_token' => Str::random(10),
            'email_verified_at' => now(),
        ];
        $user = User::create($data);
        Auth::login($user);

        return redirect()
            ->route('home')
            ->with('success', 'Registration successful! You’re now logged in.');
    }

    public function Login(Request $request)
    {
        // dd(Auth::attempt());
        // dd($request);
        $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);
        //  $remember = $request->filled('remember');

        $remember = $request->filled('remember');

        if (Auth::attempt(['email' => $request->email, 'password' => $request->password], $remember)) {
            if ($remember) {
                cookie()->queue(Cookie::make('custom_remember_flag', '1', 2880));
            }

            if (session()->has('event-register')) {
                $eventId = session('event-register');
                session()->forget('event-register');
                return redirect()->route('view-event-email', ['event_id' => $eventId])
                    ->with('success', 'Login Successfully');
            } else {
                return redirect()->route('home')->with('success', 'Login Successfully');
            }

        } else {
            return redirect()->route('home')->with('error', 'Username or Password is Incorrect');
        }
    }


    public function Logout()
    {
        Auth::logout();
        // Invalidate the session and regenerate the CSRF token
        session()->invalidate();
        session()->regenerateToken();
        Cookie::queue(Cookie::forget('custom_remember_flag'));

        return redirect()->route('home')->with('success', 'Logged out successfully');
    }
}
