<!DOCTYPE html>

<!-- =========================================================
* Sneat - Bootstrap 5 HTML Admin Template - Pro | v1.0.0
==============================================================

* Product Page: https://themeselection.com/products/sneat-bootstrap-html-admin-template/
* Created by: ThemeSelection
* License: You must have a valid license purchased in order to legally use the theme for your project.
* Copyright ThemeSelection (https://themeselection.com)

=========================================================
 -->
<!-- beautify ignore:start -->
<html
  lang="en"
  class="light-style layout-menu-fixed"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="assets/"
  data-template="vertical-menu-template-free"
>
  <head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"
    />  

    <title> <?php echo $__env->yieldContent('title'); ?> | Bhaktibhumi</title>

    <meta name="description" content="" />

    <?php echo $__env->make('Layout.header-link', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  </head>

  <body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        
        <!-- Menu -->
        <?php echo $__env->make('Layout.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">

          <!-- Navbar -->
          <?php echo $__env->make('Layout.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->

           <?php echo $__env->yieldContent('middle_content'); ?>
            <!-- / Content -->
           

            <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->

    


   <?php echo $__env->make('Layout.footer-link', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

   <script>
    <?php if(session('success')): ?>
    Swal.fire({
      icon: 'success',
      title: 'Success!',
      text: "<?php echo e(session('success')); ?>",
      confirmButtonColor: '#c34e4f',
      timer: 2500
    });
  <?php endif; ?>

    <?php if(session('error')): ?>
    Swal.fire({
      icon: 'error',
      title: 'Oops...',
      text: "<?php echo e(session('error')); ?>",
      confirmButtonColor: '#d33'
    });
  <?php endif; ?>

    <?php if(session('warning')): ?>
    Swal.fire({
      icon: 'warning',
      title: 'Warning!',
      text: "<?php echo e(session('warning')); ?>"
    });
  <?php endif; ?>

    <?php if(session('info')): ?>
    Swal.fire({
      icon: 'info',
      title: 'Note',
      text: "<?php echo e(session('info')); ?>"
    });
  <?php endif; ?>
  </script>

<script>
  $(document).on('click', '.sweet-delete-btn', function (e) {
    e.preventDefault();
    const deleteUrl = $(this).data('url');

    Swal.fire({
      title: 'Are you sure?',
      text: "You won't be able to revert this delete!",
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#d33',
      cancelButtonColor: '#948e8eff',
      confirmButtonText: 'Yes, delete it!',
      cancelButtonText: 'Cancel'
    }).then((result) => {
      if (result.isConfirmed) {
        // Redirect to delete URL
        window.location.href = deleteUrl;
      }
    });
  });
</script>


<?php echo $__env->yieldPushContent('script'); ?>

  </body>
</html><?php /**PATH C:\xampp2.0\htdocs\Bhaktibhumi-dashboard\resources\views/Layout/main.blade.php ENDPATH**/ ?>