<?php $__env->startSection('title', 'Add Rooms'); ?>

<?php $__env->startSection('middle_content'); ?>
<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light"><a href="<?php echo e(route('rooms')); ?>"
                class="text-dark">Rooms</a> /</span> Add Rooms</h4>

    <!-- Basic Layout -->
    <div class="row">
        <div class="col-xl">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Add Rooms</h5>

                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('add-store-room')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>

                        <!-- Room Number -->
                        <div class="mb-3">
                            <label class="form-label">Room Number <span class="text-danger">*</span></label>
                            <div class="input-group input-group-merge">
                                <span class="input-group-text"><i class="bx bx-hash"></i></span>
                                <input type="text" class="form-control" name="room_number" placeholder="Enter room number"
                                    value="<?php echo e(old('room_number')); ?>">
                            </div>
                            <?php $__errorArgs = ['room_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Room Title -->
                        <div class="mb-3">
                            <label class="form-label">Room Title <span class="text-danger">*</span></label>
                            <div class="input-group input-group-merge">
                                <span class="input-group-text"><i class="bx bx-building-house"></i></span>
                                <input type="text" class="form-control" name="room_title" placeholder="Deluxe AC Room"
                                    value="<?php echo e(old('room_title')); ?>">
                            </div>
                            <?php $__errorArgs = ['room_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Room Type -->
                        <div class="mb-3">
                            <label class="form-label">Room Type <span class="text-danger">*</span></label>
                            <select name="room_type" class="form-control">
                                <option value="">Select Room Type</option>
                                <option value="AC" <?php echo e(old('room_type') == 'AC' ? 'selected' : ''); ?>>AC</option>
                                <option value="Non-AC" <?php echo e(old('room_type') == 'Non-AC' ? 'selected' : ''); ?>>Non-AC</option>
                            </select>
                            <?php $__errorArgs = ['room_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Category -->
                        <div class="mb-3">
                            <label class="form-label">Category <span class="text-danger">*</span></label>
                            <select name="category" class="form-control">
                                <option value="">Select Category</option>
                                <option value="Deluxe" <?php echo e(old('category') == 'Deluxe' ? 'selected' : ''); ?>>Deluxe</option>
                                <option value="Standard" <?php echo e(old('category') == 'Standard' ? 'selected' : ''); ?>>Standard</option>
                                <option value="Suite" <?php echo e(old('category') == 'Suite' ? 'selected' : ''); ?>>Suite</option>
                            </select>
                            <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Total Rooms -->
                        <div class="mb-3">
                            <label class="form-label">Total Rooms <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" name="total_rooms" min="1"
                                value="<?php echo e(old('total_rooms', 1)); ?>">
                            <?php $__errorArgs = ['total_rooms'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Base Price -->
                        <div class="mb-3">
                            <label class="form-label">Base Price (₹) <span class="text-danger">*</span></label>
                            <input type="number" step="0.01" class="form-control" name="base_price"
                                value="<?php echo e(old('base_price')); ?>">
                            <?php $__errorArgs = ['base_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Extra Bed Price -->
                        <div class="mb-3">
                            <label class="form-label">Extra Bed Price (₹) <span class="text-danger">*</span></label>
                            <input type="number" step="0.01" class="form-control" name="extra_bed_price"
                                value="<?php echo e(old('extra_bed_price')); ?>">
                            <?php $__errorArgs = ['extra_bed_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Max Adults -->
                        <div class="mb-3">
                            <label class="form-label">Max Adults <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" name="max_adults"
                                value="<?php echo e(old('max_adults', 2)); ?>">
                            <?php $__errorArgs = ['max_adults'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Max Children -->
                        <div class="mb-3">
                            <label class="form-label">Max Children <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" name="max_children"
                                value="<?php echo e(old('max_children', 0)); ?>">
                            <?php $__errorArgs = ['max_children'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Bed Type -->
                        <div class="mb-3">
                            <label class="form-label">Bed Type <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="bed_type"
                                value="<?php echo e(old('bed_type')); ?>" placeholder="e.g., Double Bed">
                            <?php $__errorArgs = ['bed_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Amenities -->
                        <div class="mb-3">
                            <label class="form-label">Amenities <span class="text-danger">*</span></label>
                            <textarea name="amenities" class="form-control" rows="2" placeholder="WiFi, TV, Hot Water"><?php echo e(old('amenities')); ?></textarea>
                            <?php $__errorArgs = ['amenities'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Description -->
                        <div class="mb-3">
                            <label class="form-label">Description <span class="text-danger">*</span></label>
                            <textarea name="description" class="form-control" rows="3" placeholder="Enter room description"><?php echo e(old('description')); ?></textarea>
                            <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Floor Number -->
                        <div class="mb-3">
                            <label class="form-label">Floor Number <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="floor_number"
                                value="<?php echo e(old('floor_number')); ?>" placeholder="e.g., 1st Floor">
                            <?php $__errorArgs = ['floor_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Room Size -->
                        <div class="mb-3">
                            <label class="form-label">Room Size (sq ft) <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" name="room_size"
                                value="<?php echo e(old('room_size')); ?>">
                            <?php $__errorArgs = ['room_size'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <!-- Submit & Cancel -->
                        <button type="submit" class="btn btn-primary">
                            <i class="bx bx-send"></i> Submit
                        </button>

                        <a href="<?php echo e(route('rooms')); ?>" class="btn btn-secondary">
                            <i class="bx bx-x"></i> Cancel
                        </a>
                    </form>


                </div>
            </div>
        </div>
    </div>
</div>
<!-- / Content -->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('Layout.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp2.0\htdocs\Bhaktibhumi-dashboard\resources\views/rooms/add-rooms.blade.php ENDPATH**/ ?>